import { Vec } from "../Vec.mjs";
import { linesIntersect } from "../intersect.mjs";
import { Geometry2d } from "./Geometry2d.mjs";
class Edge2d extends Geometry2d {
  start;
  end;
  d;
  u;
  ul;
  constructor(config) {
    super({ ...config, isClosed: false, isFilled: false });
    const { start, end } = config;
    this.start = start;
    this.end = end;
    this.d = start.clone().sub(end);
    this.u = this.d.clone().uni();
    this.ul = this.u.len();
  }
  getLength() {
    return this.d.len();
  }
  midPoint() {
    return this.start.lrp(this.end, 0.5);
  }
  getVertices() {
    return [this.start, this.end];
  }
  nearestPoint(point) {
    const { start, end, u, ul: l } = this;
    if (l === 0) return start;
    const k = Vec.Sub(point, start).dpr(u) / l;
    const cx = start.x + u.x * k;
    if (cx < Math.min(start.x, end.x)) return start.x < end.x ? start : end;
    if (cx > Math.max(start.x, end.x)) return start.x > end.x ? start : end;
    const cy = start.y + u.y * k;
    if (cy < Math.min(start.y, end.y)) return start.y < end.y ? start : end;
    if (cy > Math.max(start.y, end.y)) return start.y > end.y ? start : end;
    return new Vec(cx, cy);
  }
  hitTestLineSegment(A, B, distance = 0) {
    return linesIntersect(A, B, this.start, this.end) || this.distanceToLineSegment(A, B) <= distance;
  }
  getSvgPathData(first = true) {
    const { start, end } = this;
    return `${first ? `M${start.toFixed()}` : ``} L${end.toFixed()}`;
  }
}
export {
  Edge2d
};
//# sourceMappingURL=Edge2d.mjs.map
